/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "DriverMCHP.h"
#include _iPLATFORMLAYER_

DriverMCHP::DriverMCHP () {

    l = log::instance();
    pl = new _iPLATFORMLAYER();
    findU4ABoards();
}

DriverMCHP::~DriverMCHP() {

    l = NULL;
    delete pl;
}

void DriverMCHP::findU4ABoards() {

    map<int,itemDsc>::iterator it;
    itemDsc ds;
    itemBoard itb;
    dscEndpoint ep;
    int temp, num;

    map<int,itemDsc> dscs (pl->getDescriptors());
    for (it = dscs.begin();it != dscs.end();it++) {
        ds = it->second;
        itb.serial = atoi((const char *)&ds.strSerialNumber[0]);
        itb.qtyep = ds.qtyep;
        for (int i=0 ; i < itb.qtyep ; i++){
            temp = (int)(((unsigned char)ds.stdEndpointDsc[i][3]) & 0x03);
            num = (int)((unsigned char)ds.stdEndpointDsc[i][2]);
            switch (temp) {
                case 0:
                    if (num > 127) {
                        ep.tdscin = CTRL_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                       ep.tdscin = NULL_IN;
                        ep.tdscout = CTRL_OUT;
                   }
                    break;
                case 1:
                    if (num > 127) {
                        ep.tdscin = ISO_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = ISO_OUT;
                    }
                    break;
                case 2:
                    if (num > 127) {
                        ep.tdscin = BULK_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = BULK_OUT;
                    }
                    break;
                case 3:
                    if (num > 127) {
                        ep.tdscin = INT_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = INT_OUT;
                    }
                    break;
            }
            ep.epnum = num;
            itb.eps[i] = ep;
        };
        boards.insert(pair<int,itemBoard>(it->first,itb));
    }
}

void DriverMCHP::dscToMCHP(int dsc, char *ep) {

    int nlen;
    char temp[10];

    sprintf(temp,"MCHP_EP%d",dsc);
    nlen = strlen(temp);
    ep[0] = '\\';
    for (int i = 0 ; i < nlen ; i++) {
        ep[i+1] = temp[i];
    };
    ep[nlen+1] = '\0';
}

int DriverMCHP::getInstance(int board) {

    return board;
};

int* DriverMCHP::getU4ABoards(int &cant) {

    int *iboards;
    map<int,itemBoard>::iterator it;

    cant = boards.size();
    if (cant > 0) {
        iboards = new int[cant];
        for (int i=0; i < cant ; i++) {
            it = boards.find(i);
            iboards[i] = it->second.serial;
        };
        return iboards;
    };
    return NULL;
}

int DriverMCHP::qtyDsc(int board) {

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return (it->second.qtyep);
}

dscEndpoint* DriverMCHP::getEndpointDsc(int board, int iter) {

    map<int,itemBoard>::iterator it;
    dscEndpoint* endps;

    it = boards.find(board);
    endps = new dscEndpoint();
    endps->epnum = it->second.eps[iter].epnum;
    endps->tdscin = it->second.eps[iter].tdscin;
    endps->tdscout = it->second.eps[iter].tdscout;
    return endps;
}

int DriverMCHP::openIn(int board, int dsc, int dscin) {

    dscin = NULL_IN; //Evita el Warning.
    char vidpid[] = _MCHP_VIDPID;
    char ep[10];
    int nbuff, inst;
    char buffer[MAX_LEN_MSG];

    inst = getInstance(board);
    dscToMCHP(dsc, ep);
    l->printLog(ep,true,true);
    nbuff = (int) MPUSBOpen(inst, vidpid, ep, MP_READ,0);
    sprintf(buffer,"Buffer: %d ready.",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

int DriverMCHP::openOut(int board, int dsc, int dscout) {

    dscout = NULL_OUT; //Evita el Warning.
    char vidpid[] = _MCHP_VIDPID;
    char ep[10];
    int nbuff, inst;
    char buffer[MAX_LEN_MSG];

    inst = getInstance(board);
    dscToMCHP(dsc, ep);
    l->printLog(ep,true,true);
    nbuff = (int) MPUSBOpen(inst, vidpid, ep, MP_WRITE,0);
    sprintf(buffer,"Buffer: %d ready.",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

bool DriverMCHP::close(int buffer) {

    bool ok = MPUSBClose((HANDLE) buffer);
    return ok;
}

bool DriverMCHP::sendInt(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendInt, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool DriverMCHP::sendCtrl(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendCtrl, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool DriverMCHP::sendIso(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendIso, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool DriverMCHP::sendBulk(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendBulk, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

char* DriverMCHP::receiveInt(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv, esperado = MAX_LEN_MSG;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveInt, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* DriverMCHP::receiveCtrl(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv, esperado = MAX_LEN_MSG;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveCtrl, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* DriverMCHP::receiveIso(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv, esperado = MAX_LEN_MSG;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveIso, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* DriverMCHP::receiveBulk(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv, esperado = MAX_LEN_MSG;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveBulk, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}
